<?php
session_start();

// Verificar se o usuário está logado
if (!isset($_SESSION['admin_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']);
    exit;
}

// Obter domínio do admin logado
$admin_domain = $_SESSION['admin_domain'] ?? "http://vod.itech2.uk";

// Função para carregar links atualizados a partir de uma URL
function carregarLinksAtualizados($url, $admin_domain) {
    $contexto = stream_context_create([
        'http' => [
            'timeout' => 10
        ]
    ]);

    $conteudo = @file_get_contents($url, false, $contexto);
    
    if ($conteudo === false) {
        header('Content-Type: application/json');
        die(json_encode(['success' => false, 'message' => "Erro ao carregar o arquivo de links. Verifique a URL."]));
    }

    $linhas = explode("\n", $conteudo);
    $links = [];
    $id = '';

    foreach ($linhas as $linha) {
        $linha = trim($linha);
        if (strpos($linha, 'ID:') === 0) {
            $id = trim(str_replace('ID:', '', $linha));
        } elseif (strpos($linha, 'Link:') === 0 && $id) {
            $link = trim(str_replace('Link:', '', $linha));
            
            // Substituir o domínio antigo pelo domínio do admin
            $link = str_replace('http://tvplus.app.br:8052', $admin_domain, $link);
            
            // Adicionar .mp4 ao final do link se não tiver
            if (!preg_match('/\.mp4($|\?)/', $link)) {
                $link .= '.mp4';
            }
            
            $links[$id] = $link;
            $id = '';
        }
    }

    return $links;
}

// ... (restante do código permanece igual)

// Função para extrair temporada e episódio do tvg-name
function extrairTemporadaEpisodio($tvgName) {
    if (preg_match('/S(\d{2})E(\d{2})/', $tvgName, $matches)) {
        return [
            'temporada' => (int)$matches[1],
            'episodio' => (int)$matches[2]
        ];
    }
    return ['temporada' => 0, 'episodio' => 0]; // Para entradas sem SXXEXX
}

// Função para processar o arquivo M3U, substituir links e ordenar por temporada/episódio
function processarM3U($m3u, $linksAtualizados) {
    $linhas = explode("\n", $m3u);
    $entradas = [];
    $buffer = '';
    $currentExtinf = '';

    // Passo 1: Coletar entradas válidas
    foreach ($linhas as $linha) {
        $linha = trim($linha);
        if (strpos($linha, '#EXTINF:') === 0) {
            $currentExtinf = $linha;
        } elseif (preg_match('/(\d+)\.mp4/', $linha, $match)) {
            $id = $match[1];
            if (isset($linksAtualizados[$id])) {
                // Extrair temporada e episódio do tvg-name
                preg_match('/tvg-name="([^"]+)"/', $currentExtinf, $tvgMatch);
                $tvgName = $tvgMatch[1] ?? '';
                $ordem = extrairTemporadaEpisodio($tvgName);
                
                // Armazenar a entrada com metadados para ordenação
                $entradas[] = [
                    'temporada' => $ordem['temporada'],
                    'episodio' => $ordem['episodio'],
                    'extinf' => $currentExtinf,
                    'link' => $linksAtualizados[$id],
                    'tvg_name' => $tvgName
                ];
            }
            $currentExtinf = '';
        }
    }

    // Passo 2: Ordenar entradas por série, temporada e episódio
    usort($entradas, function ($a, $b) {
        // Primeiro, ordenar por nome da série (tvg_name)
        $cmp = strcmp($a['tvg_name'], $b['tvg_name']);
        if ($cmp !== 0) {
            return $cmp;
        }
        // Se a série for a mesma, ordenar por temporada
        if ($a['temporada'] !== $b['temporada']) {
            return $a['temporada'] - $b['temporada'];
        }
        // Se a temporada for a mesma, ordenar por episódio
        return $a['episodio'] - $b['episodio'];
    });

    // Passo 3: Gerar o novo conteúdo M3U
    $novo_m3u = "#EXTM3U\n"; // Cabeçalho M3U
    foreach ($entradas as $entrada) {
        $novo_m3u .= $entrada['extinf'] . "\n";
        $novo_m3u .= $entrada['link'] . "\n";
    }

    return $novo_m3u;
}

// Processamento do arquivo local
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $arquivoLocal = 'SERIES CLUB.m3u';
        
        // Verificar se o arquivo existe
        if (!file_exists($arquivoLocal)) {
            throw new Exception("Arquivo 'SERIES CLUB.m3u' não encontrado no diretório.");
        }

        // Verificar tamanho do arquivo (máximo 10MB)
        $tamanhoArquivo = filesize($arquivoLocal);
        if ($tamanhoArquivo > 100 * 1024 * 1024) {
            throw new Exception("O arquivo é muito grande. O tamanho máximo permitido é 10MB.");
        }

        // Carrega os links atualizados do arquivo remoto
        $linksAtualizados = carregarLinksAtualizados('http://series.tvplus.app.br/series.txt', $admin_domain);

        // Lê o conteúdo do arquivo M3U local
        $conteudoM3U = file_get_contents($arquivoLocal);
        if ($conteudoM3U === false) {
            throw new Exception("Erro ao ler o conteúdo do arquivo M3U.");
        }

        // Processa o arquivo M3U e gera o novo conteúdo
        $novoConteudo = processarM3U($conteudoM3U, $linksAtualizados);

        // Força o download do novo arquivo M3U
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="TV PLUS - SERIES.m3u"');
        echo $novoConteudo;
        exit;
        
    } catch (Exception $e) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        exit;
    }
}

// Se acessado diretamente sem POST
header('Content-Type: application/json');
echo json_encode(['success' => false, 'message' => 'Método não permitido']);
?>