<?php
session_start();

// Verificar se o usuário está logado
if (!isset($_SESSION['admin_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']);
    exit;
}

// Obter domínio do admin logado
$admin_domain = $_SESSION['admin_domain'] ?? "http://vod.itech2.uk";

// Configurações
$api_url = "http://misto.lat/player_api.php";
$username = "marcelops4";
$password = "102030xxS";
$filmes_txt_url = "http://filmes.tvplus.app.br/Filmes.txt";

// Função para carregar links atualizados a partir do Filmes.txt
function carregarLinksAtualizados($url, $admin_domain) {
    $contexto = stream_context_create([
        'http' => [
            'timeout' => 10
        ]
    ]);

    $conteudo = @file_get_contents($url, false, $contexto);
    
    if ($conteudo === false) {
        throw new Exception("Erro ao carregar o arquivo de links. Verifique a URL.");
    }

    $linhas = explode("\n", $conteudo);
    $links = [];
    $id = '';

    foreach ($linhas as $linha) {
        $linha = trim($linha);
        if (strpos($linha, 'ID:') === 0) {
            $id = trim(str_replace('ID:', '', $linha));
        } elseif (strpos($linha, 'Link:') === 0 && $id) {
            $link = trim(str_replace('Link:', '', $linha));
            
            // Substituir o domínio antigo pelo domínio do admin
            $link = str_replace('http://tvplus.app.br:8052', $admin_domain, $link);
            
            // Adicionar .mp4 ao final do link se não tiver
            if (!preg_match('/\.mp4($|\?)/', $link)) {
                $link .= '.mp4';
            }
            
            $links[$id] = $link;
            $id = '';
        }
    }

    return $links;
}

// ... (restante do código permanece igual, apenas substituindo $novoDominio por $admin_domain)

// Função para fazer requisições à API
function fazerRequisicaoAPI($url) {
    $context = stream_context_create([
        'http' => [
            'timeout' => 30,
            'header' => 'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
        ]
    ]);
    
    $response = @file_get_contents($url, false, $context);
    
    if ($response === false) {
        throw new Exception("Erro ao conectar com a API: " . error_get_last()['message']);
    }
    
    $data = json_decode($response, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("Erro ao decodificar JSON da API: " . json_last_error_msg());
    }
    
    return $data;
}

// Função para buscar todos os filmes
function buscarFilmes($api_url, $username, $password) {
    $url = $api_url . "?action=get_vod_streams&category_id=*&username=" . $username . "&password=" . $password;
    return fazerRequisicaoAPI($url);
}

// Função para buscar categorias
function buscarCategorias($api_url, $username, $password) {
    $url = $api_url . "?action=get_vod_categories&username=" . $username . "&password=" . $password;
    return fazerRequisicaoAPI($url);
}

// Função para filtrar apenas filmes que existem no Filmes.txt
function filtrarFilmesComLinks($filmes, $linksAtualizados) {
    $filmesFiltrados = [];
    
    foreach ($filmes as $filme) {
        // Verificar se é um filme válido e se existe no Filmes.txt
        if (isset($filme['stream_id']) && 
            isset($filme['name']) && 
            $filme['stream_type'] === 'movie' &&
            isset($linksAtualizados[$filme['stream_id']])) {
            $filmesFiltrados[] = $filme;
        }
    }
    
    return $filmesFiltrados;
}

// Função para gerar o conteúdo M3U
function gerarConteudoM3U($filmes, $categorias, $linksAtualizados) {
    // Criar mapa de categorias para busca rápida
    $mapaCategorias = [];
    foreach ($categorias as $categoria) {
        $mapaCategorias[$categoria['category_id']] = $categoria['category_name'];
    }
    
    // Iniciar o conteúdo M3U
    $conteudo = "#EXTM3U\n";
    $conteudo .= "#PLAYLIST:TV PLUS - FILMES\n";
    $conteudo .= "#GENERATED: " . date('Y-m-d H:i:s') . "\n\n";
    
    $contador = 0;
    
    foreach ($filmes as $filme) {
        $id = $filme['stream_id'];
        
        // Obter informações do filme
        $nome = htmlspecialchars($filme['name']);
        $capa = isset($filme['stream_icon']) ? $filme['stream_icon'] : '';
        $categoriaId = $filme['category_id'];
        $categoriaNome = isset($mapaCategorias[$categoriaId]) ? htmlspecialchars($mapaCategorias[$categoriaId]) : 'Desconhecida';
        
        // Tentar extrair o ano do nome do filme
        $ano = 'N/A';
        if (preg_match('/\((\d{4})\)/', $nome, $matches)) {
            $ano = $matches[1];
        }
        
        // Gerar a linha EXTINF
        $extinf = "#EXTINF:-1";
        $extinf .= " tvg-name=\"$nome\"";
        $extinf .= " tvg-logo=\"$capa\"";
        $extinf .= " group-title=\"$categoriaNome\"";
        $extinf .= " ,$nome";
        
        // Usar o link do Filmes.txt (já sabemos que existe porque filtramos)
        $streamUrl = $linksAtualizados[$id];
        $contador++;
        
        // Adicionar ao conteúdo
        $conteudo .= $extinf . "\n";
        $conteudo .= $streamUrl . "\n\n";
    }
    
    return $conteudo;
}

// Processamento principal
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'generate_from_api') {
    try {
        // Carregar links atualizados do Filmes.txt
        $linksAtualizados = carregarLinksAtualizados($filmes_txt_url, $admin_domain);
        
        if (empty($linksAtualizados)) {
            throw new Exception("Nenhum link encontrado no arquivo Filmes.txt.");
        }
        
        // Buscar filmes
        $filmes = buscarFilmes($api_url, $username, $password);
        
        if (empty($filmes)) {
            throw new Exception("Nenhum filme encontrado na API.");
        }
        
        // Buscar categorias
        $categorias = buscarCategorias($api_url, $username, $password);
        
        if (empty($categorias)) {
            throw new Exception("Nenhuma categoria encontrada na API.");
        }
        
        // Filtrar apenas filmes que existem no Filmes.txt
        $filmesFiltrados = filtrarFilmesComLinks($filmes, $linksAtualizados);
        
        if (empty($filmesFiltrados)) {
            throw new Exception("Nenhum filme da API foi encontrado no Filmes.txt.");
        }
        
        // Gerar conteúdo M3U apenas com filmes filtrados
        $conteudoM3U = gerarConteudoM3U($filmesFiltrados, $categorias, $linksAtualizados);
        
        if (empty($conteudoM3U)) {
            throw new Exception("Erro ao gerar o conteúdo M3U.");
        }
        
        // Forçar o download do arquivo
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="TV PLUS - FILMES.m3u"');
        header('Content-Length: ' . strlen($conteudoM3U));
        header('Cache-Control: no-cache, no-store, must-revalidate');
        header('Pragma: no-cache');
        header('Expires: 0');
        
        echo $conteudoM3U;
        exit;
        
    } catch (Exception $e) {
        // Se ocorrer erro, retornar JSON de erro
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false, 
            'message' => $e->getMessage()
        ]);
        exit;
    }
}

// Se acessado diretamente sem POST
header('Content-Type: application/json');
echo json_encode([
    'success' => false, 
    'message' => 'Método não permitido. Use POST com action=generate_from_api'
]);
?>